LogiTrailer = {
    trailers = {} -- Variável estática para rastrear trailers existentes
}

function LogiTrailer.prerequisitesPresent(specializations)
    return true
end

function LogiTrailer.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", LogiTrailer)
    SpecializationUtil.registerEventListener(vehicleType, "onSave", LogiTrailer)
    SpecializationUtil.registerEventListener(vehicleType, "onDelete", LogiTrailer)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", LogiTrailer)
end

function LogiTrailer:onLoad(savegame)
    --print("LogiTrailer carregado com sucesso!")
    --print("Trailer propertyState= " .. tostring(self.propertyState))

    -- Inicializa estados
    self.isInitialized = false
    self.storageCreated = false
    self.isRearDoorOpen = false
    self.isLeftCurtainOpen = false
    self.isRightCurtainOpen = false
    self.storageInvisible = true

    -- Recupera ou gera o identificador único
    if savegame ~= nil then
        self.uniqueId = savegame.xmlFile:getValue(savegame.key .. "#uniqueId")
    end

    if not self.uniqueId then
        local newId
        repeat
            newId = "logitrailer_" .. math.random(1, 1000000)
        until not LogiTrailer.trailers[newId]
        self.uniqueId = newId
        --print("Novo identificador gerado: " .. self.uniqueId)
    else
        --print("Identificador carregado: " .. self.uniqueId)

        -- Verifica o estado das portas e atualiza apenas se o storage existir
        --if LogiAgroLoader.storages[self.uniqueId] then
            local rearDoorOpen = self.spec_foldable and self.spec_foldable.foldAnimTime == 0
            local leftCurtainOpen = self.spec_animatedVehicle and self.spec_animatedVehicle:getAnimationTime("coverAnimationLeftFront") == 1
            local rightCurtainOpen = self.spec_animatedVehicle and self.spec_animatedVehicle:getAnimationTime("coverAnimationRightFront") == 1

            self.isRearDoorOpen = rearDoorOpen
            self.isLeftCurtainOpen = leftCurtainOpen
            self.isRightCurtainOpen = rightCurtainOpen

            -- Determinar área de spawn ativa
            local activeSpawnArea = nil
            if rearDoorOpen then
                activeSpawnArea = 1
            elseif leftCurtainOpen then
                activeSpawnArea = 2
            elseif rightCurtainOpen then
                activeSpawnArea = 3
            end

            -- Se alguma porta estiver aberta, atualizar posição, visibilidade e spawn
            local x, y, z = getWorldTranslation(self.rootNode)
            local rx, ry, rz = getWorldRotation(self.rootNode)

            if activeSpawnArea then
                LogiAgroLoader:moveStorage(self.uniqueId, x, y, z, rx, ry, rz)
                LogiAgroLoader:makeStorageVisible(self.uniqueId)
                LogiAgroLoader:setActiveSpawnArea(self.uniqueId, activeSpawnArea)
                --print("Área de spawn ativa movida para índice " .. activeSpawnArea .. " no storage '" .. self.uniqueId .. "'.")
                self.storageInvisible = false
            else
                -- Se todas as portas estão fechadas, torna invisível
                LogiAgroLoader:makeStorageInvisible(self.uniqueId)
                --print(self.uniqueId .. " - Storage tornado invisível (todas portas fechadas).")
                self.storageInvisible = true
            end
        --end

    end
    self.isInitialized = true
end

function LogiTrailer:onSave(xmlFile, key)
    if self.uniqueId then
        xmlFile:setValue(key .. "#uniqueId", self.uniqueId)
    end
end

function LogiTrailer:onDelete()
    if self.uniqueId and LogiAgroLoader.storages[self.uniqueId] then
        LogiAgroLoader:deleteStorage(self.uniqueId)
        --print("Storage excluído para o trailer: " .. self.uniqueId)
    end

    if LogiTrailer.trailers[self.uniqueId] then
        LogiTrailer.trailers[self.uniqueId] = nil
        --print("Trailer removido da tabela estática: " .. self.uniqueId)
    end
end


function LogiTrailer:onUpdate(dt)
    if not self.isInitialized or self.propertyState == 5 then
        return
    end

    -- Verificar se o trailer está em movimento
    local isMoving = math.abs(self.lastSpeedReal) > 0.001
    local stateChanged = false

    if isMoving ~= self.isMoving then
        self.isMoving = isMoving
        stateChanged = true
    end

    -- Verificar estado da porta traseira (apenas se a animação terminou)
    if self.spec_foldable ~= nil then
        local rearDoorAnimTime = self.spec_foldable.foldAnimTime or 0
        local rearDoorOpen = rearDoorAnimTime == 0  -- Animação concluída

        if rearDoorOpen ~= self.isRearDoorOpen then
            self.isRearDoorOpen = rearDoorOpen
            stateChanged = true
            --print(self.uniqueId .. " - Porta Traseira: " .. (self.isRearDoorOpen and "Aberta" or "Fechada"))
        end
    end

    -- Verificar estado da cortina esquerda (apenas se a animação terminou)
    if self.spec_animatedVehicle ~= nil then
        local leftCurtainAnimTime = self.spec_animatedVehicle:getAnimationTime("coverAnimationLeftFront") or 0
        local leftCurtainOpen = leftCurtainAnimTime == 1

        if leftCurtainOpen ~= self.isLeftCurtainOpen then
            self.isLeftCurtainOpen = leftCurtainOpen
            stateChanged = true
            --print(self.uniqueId .. " - Cortina Esquerda: " .. (self.isLeftCurtainOpen and "Aberta" or "Fechada"))
        end
    end

    -- Verificar estado da cortina direita (apenas se a animação terminou)
    if self.spec_animatedVehicle ~= nil then
        local rightCurtainAnimTime = self.spec_animatedVehicle:getAnimationTime("coverAnimationRightFront") or 0
        local rightCurtainOpen = rightCurtainAnimTime == 1

        if rightCurtainOpen ~= self.isRightCurtainOpen then
            self.isRightCurtainOpen = rightCurtainOpen
            stateChanged = true
            --print(self.uniqueId .. " - Cortina Direita: " .. (self.isRightCurtainOpen and "Aberta" or "Fechada"))
        end
    end

    -- Determinar área de spawn ativa
    local activeSpawnArea = nil
    if self.isRearDoorOpen then
        activeSpawnArea = 1
    elseif self.isLeftCurtainOpen then
        activeSpawnArea = 2
    elseif self.isRightCurtainOpen then
        activeSpawnArea = 3
    end

    -- Somente realizar ações se algo mudou
    if stateChanged then
        -- Criar storage se necessário
        if not self.storageCreated and not self.isMoving and activeSpawnArea ~= nil then
            local x, y, z = getWorldTranslation(self.rootNode)
            local rx, ry, rz = getWorldRotation(self.rootNode)
            LogiAgroLoader:createStorage(self.uniqueId, x, y, z, rx, ry, rz)
            self.storageCreated = true
            --print("Storage criado para o trailer: " .. self.uniqueId)
        end

        -- Manipular storage
        if LogiAgroLoader.storages[self.uniqueId] then
            if self.isMoving or activeSpawnArea == nil then
                -- Tornar invisível se em movimento ou todas as portas/cortinas fechadas
                if not self.storageInvisible then
                    LogiAgroLoader:makeStorageInvisible(self.uniqueId)
                    self.storageInvisible = true
                    --print(self.uniqueId .. " - Storage tornado invisível.")
                end
            else
                -- Atualizar storage apenas se necessário
                local x, y, z = getWorldTranslation(self.rootNode)
                local rx, ry, rz = getWorldRotation(self.rootNode)

                LogiAgroLoader:moveStorage(self.uniqueId, x, y, z, rx, ry, rz)
                LogiAgroLoader:makeStorageVisible(self.uniqueId)
                --print(self.uniqueId .. " - Storage atualizado e visível.")

                if activeSpawnArea ~= self.lastSpawnArea then
                    LogiAgroLoader:setActiveSpawnArea(self.uniqueId, activeSpawnArea)
                    --print("Área de spawn ativa movida para índice " .. activeSpawnArea .. " no storage '" .. self.uniqueId .. "'.")
                end

                self.lastSpawnArea = activeSpawnArea
                self.storageInvisible = false
            end
        end
    end
end
