-- Author:Miodowy
-- Name:HorseCareManage

HorseCareManager = {}
HorseCareManager.costFactor = 2

function HorseCareManager:adjustHourlyBehavior(originalCallback)
    return function(instance, ...)
        originalCallback(instance, ...)

        local currentHour = g_currentMission.environment.currentHour
        if currentHour == 9 and instance.typeName == "horseHusbandry" then
            local horseClusters = instance:getClusterSystem().clusters

            for _, horse in pairs(horseClusters) do
                horse.riding = 100
                horse.fitness = 100
                horse.dirt = 0
            end
        end
    end
end

PlaceableHusbandry.onHourChanged = HorseCareManager:adjustHourlyBehavior(PlaceableHusbandry.onHourChanged)


