Sales = {}

Sales.modDirectory = g_currentModDirectory
Sales.name = g_currentModName;
Sales.maxAge = 60 -- greater than 6
Sales.maxOperatingTime = 60
Sales.miscSalesItems = {}
Sales.GENERATED_HOURLY_CHANCE_MISC = 50

function Sales:init()

    MissionManager.initDataStructures = Utils.appendedFunction(MissionManager.initDataStructures, Sales.initDataStructures)
    MissionManager.loadMapData = Utils.appendedFunction(MissionManager.loadMapData, Sales.initDataStructures)

    --VehicleSaleSystem.generateRandomVehicle = Utils.appendedFunction(VehicleSaleSystem.generateRandomVehicle, Sales.generateRandomVehicle)
    VehicleSaleSystem.addSale = Utils.prependedFunction(VehicleSaleSystem.addSale, Sales.addSale)
    VehicleSaleSystem.addSale = Utils.appendedFunction(VehicleSaleSystem.addSale, Sales.addNotification)

    ShopController.buy = Utils.prependedFunction(ShopController.buy, Sales.buyItem)

    if g_server ~= nil then
        Sales:subscribeHour();
    end
    Sales:addCommands()
end

function Sales:buyItem(a,b,c,d,e,f,g)
    print(a)
end

function Sales:initDataStructures()
    VehicleSaleSystem.BUYPRICE_FACTOR = 1.1 --1.1
    VehicleSaleSystem.GENERATED_HOURLY_CHANCE = 0.20 --0.15
    VehicleSaleSystem.MAX_GENERATED_ITEM_DURATION = 48 --40
    VehicleSaleSystem.MAX_GENERATED_ITEMS = 50 --5
    VehicleSaleSystem.MAX_MULTIPLAYER_ITEM_DURATION = 72 -- 40
    VehicleSaleSystem.MAX_MULTIPLAYER_ITEMS = 50 -- 20
    VehicleSaleSystem.MIN_GENERATED_ITEM_DURATION = 10 --20
    VehicleSaleSystem.MIN_MULTIPLAYER_ITEM_DURATION = 10 --20
    VehicleSaleSystem.MINIMUM_ITEM_VALUE =  7500 --10000
    VehicleSaleSystem.MULTIPLAYER_ACCEPT_CHANCE = 0.9 --0.8
end

function Sales:addCommands()
    addConsoleCommand("rgGenerateSale", "Generates Random vehicle for Sale ", "commandGenerateRandomVehicle", self)
    addConsoleCommand("rgGenerateBrandSale", "Generates Random Brand for Sale ", "commandGenerateBrandSale", self)
end



-- VehicleSaleSystem.generateRandomVehicle() returns the new Vehicle
function Sales:commandGenerateRandomVehicle(a,b,c,d,e,f,g)
    if not g_currentMission.isMasterUser then
        print('This command is only allowed for admins')
        return
    end
    local vehicle = VehicleSaleSystem.generateRandomVehicle()
    VehicleSaleSystem.addSale(g_currentMission.vehicleSaleSystem, vehicle)
end


function Sales:commandGenerateBrandSale()
    if not g_currentMission.isMasterUser then
        print('This command is only allowed for admins')
        return
    end

    local brand = self:generateBrandSale()

    table.insert(Sales.miscSalesItems,brand)

end

function Sales:subscribeHour()
    g_messageCenter:subscribe(MessageType.HOUR_CHANGED, Sales.periodChanged, self)
end

function Sales:periodChanged(hour)
    -- remove Brand/Misc
    --self.addMiscSale()

end

function Sales:addMiscSale()
    local shouldGenerate = math.random(1, 100) <= Sales.GENERATED_HOURLY_CHANCE_MISC
    if not shouldGenerate then
        return
    end

    local sale = Sales:generateRandomMiscSale()

    table.insert(Sales.miscSalesItems, sale)

end

function Sales:generateRandomMiscSale()
    local miscSale

    local isBrandSale = math.random(1, 100) > 30

    if isBrandSale then
        miscSale = self:generateBrandSale()
    else
        miscSale = self:generateCategorySale()
    end

    return miscSale
end

function Sales:generateMiscRebate()
     --Todo Min random
    return math.random(2, 15)
end

function Sales:generateBrandSale()
    local brandIndex = math.random(1, g_brandManager.numOfBrands)
    local brand = g_brandManager:getBrandByIndex(brandIndex)

    return {
            title = brand.title,
            image = brand.image,
            timeLeft = math.random(3,24),
            rebate = self.generateMiscRebate()
        }
end

function Sales:generateCategorySale()
    local categories = g_storeManager.categories
    local index = math.random(1,table.getn(categories))
    local category = categories[index]

    return {title = category.title,
            image=category.image,
            timeLeft = math.random(3,24),
            rebate = self.generateMiscRebate()
        }
end


function Sales:addSale(vehicle)

    --reset the damage
    local newPrice = vehicle.price * 0.10
    vehicle.price = vehicle.price + (newPrice * vehicle.damage)
    vehicle.damage = 0

    local xmlFile = string.lower(vehicle.xmlFilename)
    local storeItem = g_storeManager.xmlFilenameToItem[xmlFile]

    if storeItem ~= nil then
        vehicle.age = math.random(6.1, Sales.maxAge)
        vehicle.operatingTime = math.random(0.1, Sales.maxOperatingTime)

        local agePercent = (vehicle.age - 6) / (Sales.maxAge - 6) * 0.2
        local timePercent = (vehicle.operatingTime) / (Sales.maxOperatingTime) * 0.4

        local configPrice = 0
        for configName, configs in vehicle.boughtConfigurations do
            for configId, isBought in configs do
                local test = storeItem.configurations[configName]
                test = test[configId]

                configPrice += storeItem.configurations[configName][configId].price
            end
        end

        local agePrice = (storeItem.price + configPrice) * agePercent
        local timePrice = (storeItem.price + configPrice) * timePercent

        vehicle.price = storeItem.price - agePrice - timePrice
        vehicle.operatingTime = vehicle.operatingTime * 1000 * 60 * 60

    end

end

function Sales:addNotification(vehicle)
    local text = "New Sale available"

    local xmlFile = string.lower(vehicle.xmlFilename)
    local storeItem = g_storeManager.xmlFilenameToItem[xmlFile]

    if storeItem ~= nil then
        local brandName = g_brandManager:getBrandByIndex(storeItem.brandIndex)
        text = g_i18n.modEnvironments[Sales.name].texts["now_in_sale"]..": "
        if brandName ~= nil then
            text = text .. brandName.title .. " "
        end
        text = text .. storeItem.name .. ": " .. math.round(vehicle.price) .. " ".. Sales.getMoneySymbol()
    end
    g_currentMission.hud:addSideNotification(HUD.COLOR.DEFAULT, text)
end

function Sales.getMoneySymbol()
    if g_gameSettings.moneyUnit == 2 then
        return "$"
    elseif g_gameSettings.moneyUnit == 3 then
        return "£"
    end
    return "€"
end

Sales:init()