--[[
Copyright (C) GtX (Andy), 2021

Author: GtX | Andy
Date: 12.04.2021
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]

local validationFail
local supplyTransportManager

local modName = g_currentModName
local modDirectory = g_currentModDirectory
local modSettingsDirectory = g_modSettingsDirectory

local buildId = 3
local versionString = "0.0.0.0"

local function isActive()
    return supplyTransportManager ~= nil and g_modIsLoaded[modName]
end

local function unload()
    if g_globalMods ~= nil then
        g_globalMods.supplyTransportManager = nil
    end

    if isActive() then
        supplyTransportManager:delete()
    end

    g_supplyTransportManager = nil
    supplyTransportManager = nil
end

local function validateMod()
    local mod = g_modManager:getModByName(modName)

    if mod == nil or g_iconGenerator ~= nil or g_isEditor then
        return false
    end

    versionString = mod.version or versionString

    if mod.modName == "FS25_SupplyTransportContracts" or mod.modName == "FS25_SupplyTransportContracts_update" then
        if mod.author ~= nil and #mod.author == 3 then
            return true
        end
    end

    local validationText = "This mod is outdated and not working properly. Please update the mod first!"

    if g_i18n:hasText("ui_modsCannotActivateBlockedModUpdate") then
        validationText = g_i18n:getText("ui_modsCannotActivateBlockedModUpdate")
    end

    validationText = string.format("- %s -\n\n%s", mod.modName, validationText)

    validationFail = {
        startUpdateTime = 2000,

        update = function(self, dt)
            self.startUpdateTime = self.startUpdateTime - dt

            if self.startUpdateTime < 0 then
                if g_dedicatedServer == nil then
                    if not g_gui:getIsGuiVisible() then
                        local yesText = g_i18n:getText("button_modHubDownload")
                        local noText = g_i18n:getText("button_ok")

                        YesNoDialog.show(self.openModHubLink, nil, validationText, mod.title, yesText, noText, DialogElement.TYPE_WARNING)
                    end
                else
                    print("\n" .. validationText .. "\n    - https://farming-simulator.com/mods.php?&title=fs2025&filter=org&org_id=129652&page=0" .. "\n")
                    self.openModHubLink(false)
                end
            end
        end,

        openModHubLink = function(yes)
            if yes then
                openWebFile("mods.php?title=fs2025&filter=org&org_id=129652&page=0", "")
            end

            removeModEventListener(validationFail)
            validationFail = nil
        end
    }

    addModEventListener(validationFail)

    return false
end

local function init()
    if g_globalMods == nil then
        g_globalMods = {}
    end

    if g_globalMods.supplyTransportManager ~= nil then
        Logging.error("Validation of '%s' failed, script set has already been loaded by '%s'.", modName, g_globalMods.supplyTransportManager.modName or "Unknown")

        return false
    end

    if validateMod() then
        source(g_currentModDirectory .. "scripts/missions/SupplyTransportManager.lua")
        source(g_currentModDirectory .. "scripts/missions/SupplyTransportMission.lua")

        supplyTransportManager = SupplyTransportManager.new(buildId, versionString, modName, modDirectory)
        -- supplyTransportManager:consoleCommandSetDebugState("true")

        g_globalMods.supplyTransportManager = supplyTransportManager
        g_supplyTransportManager = supplyTransportManager

        FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)

        g_missionManager:registerMissionType(SupplyTransportMission, SupplyTransportMission.NAME, SupplyTransportMission.DEFAULT_MAX_NUM_INSTANCES)
    else
        Logging.error("[%s] Failed to initialise / validate mod!", modName)
    end
end

init()
