--[[
    VehicleLoadingUtil

	Partial Re-Implementation of FS22's VehicleLoadingUtil to load Vehicles.

	@author: 		BayernGamers
	@date: 			02.03.2025
	@version:		1.0

	History:		v1.0 @02.03.2025 - initial implementation in FS 25
					-------------------------------------------------------------------------------------------
]]

VehicleLoadingUtil = {}

function VehicleLoadingUtil.loadVehicleFromXML(filename, location, rotation, isSaved, price, propertyState, ownerFarmId, isRegistered, forceServer, configurations, savegameData, callback, callbackTarget, callbackArguments)
	local storeItem = g_storeManager:getItemByXMLFilename(filename)

	if storeItem ~= nil then
		if g_currentMission.slotSystem:hasEnoughSlots(storeItem) then
			local data = VehicleLoadingData.new()
			data:setStoreItem(storeItem)
			data:setPropertyState(propertyState or VehiclePropertyState.OWNED)
			data:setPosition(location.x, location.y, location.z)
			data:setRotation(rotation.xRot, rotation.yRot, rotation.zRot)
			data:setIsSaved(isSaved)
			data:setOwnerFarmId(ownerFarmId)
			data:setIsRegistered(isRegistered)
			data:setForceServer(forceServer)
			data:setConfigurations(configurations or {})
			data:setSavegameData(savegameData)
			
			data:load(callback, callbackTarget, callbackArguments)
		else
			g_currentMission:addMoney(storeItem.price, farmId, MoneyType.SHOP_VEHICLE_SELL, true)
			Logging.warning("Too many slots in use. Selling vehicle '%s' for '%d'", filename, storeItem.price)
		end
	end
end